<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MSudi extends CI_Model
{
    function AddData($tabel, $data = array())
    {
        $this->db->insert($tabel, $data);
        $this->db->insert_id();
    }

    function AddDataBatch($tabel, $data = array())
    {
        $this->db->insert_batch($tabel, $data);
    }

    function UpdateData($tabel, $fieldid, $fieldvalue, $data = array())
    {
        $this->db->where($fieldid, $fieldvalue)->update($tabel, $data);
    }

    function DeleteData($tabel, $fieldid, $fieldvalue)
    {
        $this->db->where($fieldid, $fieldvalue)->delete($tabel);
    }

    function GetData($tabel)
    {
        $query = $this->db->get($tabel);
        return $query->result();
    }

    function GetData2($tabel)
    {
        $query = $this->db->get($tabel);
        return $query;
    }

    function GetDataWhere($tabel, $id, $nilai)
    {
        $this->db->where($id, $nilai);
        $query = $this->db->get($tabel);
        return $query;
    }
    function GetDataWhere3($tabel, $id, $nilai)
    {
        $this->db->where($id, $nilai);
        $query = $this->db->get($tabel);
        return $query->result();
    }

    function hitungtransaksi()
    {

        $query =  $this->db->query("SELECT SUM(a.`harga_jual` * a.`jumlah_beli`) AS total  FROM `tbl_penampung` a ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function untung_pdg()
    {

        $query =  $this->db->query("SELECT SUM((a.`harga_jual` - a.`harga_satuan`) * a.`jumlah_beli`) AS keuntungan 
        FROM
       `tbl_penampung` a  ");
        if ($query->num_rows() > 0) {
            return $query->row()->keuntungan;
        } else {
            return 0;
        }
    }

    function hitungkeuntungan()
    {

        $this->db->select_sum('keuntungan_pdg');


        $this->db->where('id_pedagang', $this->session->userdata('ses_id'));
        $query = $this->db->get('tbl_riwayattrans');
        if ($query->num_rows() > 0) {
            return $query->row()->keuntungan_pdg;
        } else {
            return 0;
        }
    }

    function totalBarang()
    {
        $this->db->where('id_pedagang', $this->session->userdata('ses_id'));
        $query = $this->db->get('tbl_barang');

        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function GetNamaPembeli()
    {
        $a = date('Y-m-d');
        $this->db->select('*');
        $this->db->from('tbl_riwayattrans');
        $this->db->join('tbl_siswa', 'tbl_siswa.nis=tbl_riwayattrans.nis');
        $array = array('id_pedagang' => $this->session->userdata('ses_id'), 'tgl_transaksi' => $a);
        $this->db->where($array);
        $query = $this->db->get();
        return $query->result_array();
    }

    function GetHistoriTra()
    {
        $a = date('Y-m-d');
        $this->db->select('*');
        $this->db->from('tbl_riwayattrans');
        $this->db->join('tbl_siswa', 'tbl_siswa.nis=tbl_riwayattrans.nis');
        $array = array('tgl_transaksi' => $a);
        $this->db->where($array);
        $query = $this->db->get();
        return $query->result_array();
    }


    function hitungPemasukanSPP()
    {

        $this->db->select_sum('jml_pembayaran');
        $this->db->where('kategori_trans', 'SPP');
        $query = $this->db->get('tbl_transaksi');
        if ($query->num_rows() > 0) {
            return $query->row()->jml_pembayaran;
        } else {
            return 0;
        }
    }

    function hitungpotongantransaksi()
    {

        $this->db->select_sum('isi_data');
        $this->db->where('ket_data', 'Biaya Komisi Toko');
        $query = $this->db->get('tbl_data');
        if ($query->num_rows() > 0) {
            return $query->row()->isi_data;
        } else {
            return 0;
        }
    }

    function hitungpotonganPedagang()
    {

        $this->db->select_sum('isi_data');
        $this->db->where('ket_data', 'Biaya Komisi Pedagang');
        $query = $this->db->get('tbl_data');
        if ($query->num_rows() > 0) {
            return $query->row()->isi_data;
        } else {
            return 0;
        }
    }

    function hitungpotonganBulanan()
    {
        $this->db->select_sum('isi_data');
        $this->db->where('ket_data', 'Biaya Admin');
        $query = $this->db->get('tbl_data');
        if ($query->num_rows() > 0) {
            return $query->row()->isi_data;
        } else {
            return 0;
        }
    }
    function totalSubSPP($kd)
    {
        $this->db->select('options, count(*)');
        $this->db->where('options', 'L');
        $this->db->where('kd_pembayaran', $kd);
        // $query = $this->db->get('tbl_pembayaran');
        return $this->db->count_all_results('tbl_pembayaran');
    }


    function hitunglimit($day)
    {
        $this->db->select_sum('total_harga');
        $this->db->where('id_hari=' . $day);
        $this->db->where('nis', 2815308999);
        $query = $this->db->get('tbl_riwayattrans');
        if ($query->num_rows() > 0) {
            return $query->row()->total_harga;
        } else {
            return 0;
        }
    }

    function GetDataWhere2($tabel, $id, $nilai, $id2, $nilai2)
    {
        $this->db->where($id, $nilai);
        $this->db->where($id2, $nilai2);
        $query = $this->db->get($tabel);
        return $query->result();
    }

    function GetDataWhere22($tabel, $id, $nilai, $id2, $nilai2)
    {
        $this->db->where($id, $nilai);
        $this->db->where($id2, $nilai2);
        $query = $this->db->get($tabel);
        return $query;
    }

    function GetDataWhere4($tabel, $id, $nilai, $id2, $nilai2, $id3, $nilai3)
    {
        $this->db->where($id, $nilai);
        $this->db->where($id2, $nilai2);
        $this->db->where($id3, $nilai3);
        $query = $this->db->get($tabel);
        return $query;
    }

    function GetDataJoinWhere1($tabel, $tabel2, $onjoin, $id, $nilai)
    {
        $this->db->join($tabel2, $onjoin);
        $this->db->where($id, $nilai);
        $query = $this->db->get($tabel);
        return $query->result();
    }

    function GetDataJoinWhere2($tabel, $tabel2, $onjoin, $id, $nilai)
    {
        $this->db->join($tabel2, $onjoin);
        $this->db->where($id, $nilai);
        $query = $this->db->get($tabel);
        return $query;
    }

    function Get()
    {
        $this->db->select('*');
        $this->db->from('tbl_berkassiswa');
        $this->db->join('tbl_siswa', 'tbl_siswa.kd_siswa=tbl_berkassiswa.kd_siswa');
        $query = $this->db->get();
        return $query->result();
    }

    function Get2()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $query = $this->db->get();
        return $query->result();
    }


    function Get3($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get4($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_pembayaran', 'tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_pembayaran=tbl_pembayaran.kd_pembayaran');
        // $this->db->join('tbl_tabungansiswa','tbl_tabungansiswa.kd=tbl_siswa.kd_tabungan');
        $this->db->where('kd_siswa=' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get5($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kaosolahraga', 'tbl_uang_kaosolahraga.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get6($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_gamis', 'tbl_uang_gamis.uang_gamis=tbl_siswa.uang_gamis');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get7($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kitab', 'tbl_uang_kitab.uang_kitab=tbl_siswa.uang_kitab');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get8($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_ujian', 'tbl_uang_ujian.uang_ujian=tbl_siswa.uang_ujian');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get9($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_prakerin', 'tbl_uang_prakerin.uang_prakerin=tbl_siswa.uang_prakerin');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get10($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_seragam_sklh', 'tbl_uang_seragam_sklh.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get11($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get12($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get13($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kesehatan', 'tbl_uang_kesehatan.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get14($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pekan', 'tbl_uang_pekan.uang_pekan=tbl_siswa.uang_pekan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get15($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_raport', 'tbl_uang_raport.uang_raport=tbl_siswa.uang_raport');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get16($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_formulir', 'tbl_uang_formulir.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function Get17($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_ziarah', 'tbl_uang_ziarah.uang_ziarah=tbl_siswa.uang_ziarah');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }



    function GetMonitoringBulanan($bln)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_pembayaran=tbl_siswa.kd_pembayaran');
        $this->db->join('tbl_pembayaran', 'tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->group_by('nis');
        $this->db->where('bulan', $bln);
        // $this->db->where('kategori_trans', 'SPP');
        $query = $this->db->get();
        return $query->result();
    }


    function GetDatalocation()
    {
        $this->db->select('location');
        $this->db->from('location');
        $this->db->where('kd_location', 1);
        return $this->db->get()->row()->location;
    }

    function replacebulan($hari)
    {
        switch ($hari) {
            case "1":
                return "1";
                break;
            case "2":
                return "2";
                break;
            case "3":
                return "3";
                break;
            case "4":
                return "4";
                break;
            case "5":
                return "5";
                break;
            case "6":
                return "6";
                break;
            case "7":
                return "7";
                break;
            case "8":
                return "8";
                break;
            case "9":
                return "9";
                break;
            case "10":
                return "10";
                break;
            case "11":
                return "11";
                break;
            case "12":
                return "12";
                break;
            default:
                break;
        }
    }

    function Getbangunan3()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->order_by('kd_siswa', 'DESC');
        $query = $this->db->get();
        // if($query -> num_rows() == 0){
        //        $row = $query->row(); 
        //       $this->session->set_userdata('no_uangbangunan', $row->no_uangbangunan);
        //      $this->session->set_userdata('uangB', $row->uang_bangunan);
        //        $this->session->set_userdata('kd_siswa',$row->kd_siswa);
        //        return $query;
        //  }
        return $query->result();
    }

    function GetKOR()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kaosolahraga', 'tbl_uang_kaosolahraga.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_kaos_olahraga', $row->uang_kaos_olahraga);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetGamis()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_gamis', 'tbl_uang_gamis.uang_gamis=tbl_siswa.uang_gamis');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            // $this->session->set_userdata('uang_gamis', $row->uang_gamis);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            // $this->session->set_userdata('kd_siswa',$row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetAlmameter()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kitab', 'tbl_uang_kitab.uang_kitab=tbl_siswa.uang_kitab');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            //  $this->session->set_userdata('uang_kitab', $row->uang_kitab);
            // // $this->session->set_userdata('uangB', $row->uang_bangunan);
            //   $this->session->set_userdata('kd_siswa',$row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetUjian()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_ujian', 'tbl_uang_ujian.uang_ujian=tbl_siswa.uang_ujian');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            //  $this->session->set_userdata('uang_kitab', $row->uang_kitab);
            // // $this->session->set_userdata('uangB', $row->uang_bangunan);
            //   $this->session->set_userdata('kd_siswa',$row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetPrakerin()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_prakerin', 'tbl_uang_prakerin.uang_prakerin=tbl_siswa.uang_prakerin');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_prakerin', $row->uang_prakerin);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetSeragamSklh()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_seragam_sklh', 'tbl_uang_seragam_sklh.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_seragam_sklh', $row->uang_seragam_sklh);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetZiarah()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_ziarah', 'tbl_uang_ziarah.uang_ziarah=tbl_siswa.uang_ziarah');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_ziarah', $row->uang_ziarah);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function GetPekan()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pekan', 'tbl_uang_pekan.uang_pekan=tbl_siswa.uang_pekan');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_pekan', $row->uang_pekan);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function Getspp()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        //  $this->db->join('tbl_pembayaran','tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->select('nama_siswa');         
        // $this->db->distinct('nama_siswa');
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_pembayaran', $row->kd_pembayaran);
            $this->session->set_userdata('uangSPP', $row->uang_spp_smt1);
            // $this->session->set_userdata('kd_siswa',$row->kd_siswa);
            $this->session->set_userdata('options', $row->options);
            $this->session->set_userdata('kd_pem', $row->kd_pem);
            return $query;
        }
        return $query->result();
    }

    function AddData2($tabel, $data = array(), $kd_siswa)
    {
        $this->db->insert($tabel, $data);
        $this->db->where($kd_siswa);
    }


    function joinanUB($keyword)
    {
        $this->db->from('tbl_transaksi_ub');
        $this->db->join('tbl_siswa', 'tbl_siswa.kd_siswa=tbl_transaksi_ub.kd_siswa');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.kd_uangbangunan=tbl_transaksi_ub.kd_uangbangunan');

        $this->db->like('nama', $keyword);
        $query = $this->db->get();
        return $query->result();
    }


    function GetSiswa($new_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->where('tahun_ajaran =' . $new_id);
        $query = $this->db->get();

        $this->session->set_userdata('kd_siswa');
        return $query;
    }

    function GetBerkas()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_berkassiswa', 'tbl_berkassiswa.kd_berkassiswa=tbl_siswa.kd_berkassiswa');
        $query = $this->db->get();
        return $query->result();
    }

    function get_product_keyword($keyword)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');

        $this->db->like('nama_siswa', $keyword);
        // $this->db->or_like('kd_siswa',$keyword);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);





            return $query->result();
        }
    }
    function joinan($kd_siswa)
    {
        $this->db->from('tbl_pembayaran');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_pembayaran.no_administrasi');
        $this->db->join('tbl_siswa', 'tbl_siswa.kd_pembayaran=tbl_pembayaran.kd_pembayaran');
        $this->db->join('tbl_bulan', 'tbl_bulan.NO=tbl_pembayaran.bulan');
        $this->db->join('tbl_tabungansiswa', 'tbl_tabungansiswa.kd=tbl_siswa.kd_tabungan');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_pembayaran=tbl_pembayaran.kd_pembayaran'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_pem', $row->kd_pem);





            return $query;
        }
        return $query->result();
    }

    function joinanUBB($kd_siswa)
    {
        $this->db->from('tbl_uang_bangunan');
        $this->db->join('tbl_siswa', 'tbl_siswa.no_uangbangunan=tbl_uang_bangunan.no_uangbangunan');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanKOR($kd_siswa)
    {
        $this->db->from('tbl_uang_kaosolahraga');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_kaos_olahraga=tbl_uang_kaosolahraga.uang_kaos_olahraga');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanGamis($kd_siswa)
    {
        $this->db->from('tbl_uang_gamis');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_gamis=tbl_uang_gamis.uang_gamis');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanKitab($kd_siswa)
    {
        $this->db->from('tbl_uang_kitab');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_kitab=tbl_uang_kitab.uang_kitab');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanUjian($kd_siswa)
    {
        $this->db->from('tbl_uang_ujian');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_ujian=tbl_uang_ujian.uang_ujian');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanPrakerin($kd_siswa)
    {
        $this->db->from('tbl_uang_prakerin');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_prakerin=tbl_uang_prakerin.uang_prakerin');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanSeragamSklh($kd_siswa)
    {
        $this->db->from('tbl_uang_seragam_sklh');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_seragam_sklh=tbl_uang_seragam_sklh.uang_seragam_sklh');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanZiarah($kd_siswa)
    {
        $this->db->from('tbl_uang_ziarah');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_ziarah=tbl_uang_ziarah.uang_ziarah');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function joinanPekan($kd_siswa)
    {
        $this->db->from('tbl_uang_pekan');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_pekan=tbl_uang_pekan.uang_pekan');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }


    function joinan2($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->join('tbl_pembayaran','tbl_pembayaran.kd_pembayaran=tbl_transaksi.kd_pembayaran'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function joinan22($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinKOR($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $this->db->join('tbl_uang_kaosolahraga', 'tbl_uang_kaosolahraga.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinGamis($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_gamis=tbl_siswa.uang_gamis');
        $this->db->join('tbl_uang_gamis', 'tbl_uang_gamis.uang_gamis=tbl_siswa.uang_gamis');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinKitab($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kitab=tbl_siswa.uang_kitab');
        $this->db->join('tbl_uang_kitab', 'tbl_uang_kitab.uang_kitab=tbl_siswa.uang_kitab');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinUjian($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_ujian=tbl_siswa.uang_ujian');
        $this->db->join('tbl_uang_ujian', 'tbl_uang_ujian.uang_ujian=tbl_siswa.uang_ujian');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinPrakerin($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_prakerin=tbl_siswa.uang_prakerin');
        $this->db->join('tbl_uang_prakerin', 'tbl_uang_prakerin.uang_prakerin=tbl_siswa.uang_prakerin');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinSeragamSklh($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $this->db->join('tbl_uang_seragam_sklh', 'tbl_uang_seragam_sklh.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinZiarah($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_ziarah=tbl_siswa.uang_ziarah');
        $this->db->join('tbl_uang_ziarah', 'tbl_uang_ziarah.uang_ziarah=tbl_siswa.uang_ziarah');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function DataJoinPekan($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_pekan=tbl_siswa.uang_pekan');
        $this->db->join('tbl_uang_pekan', 'tbl_uang_pekan.uang_pekan=tbl_siswa.uang_pekan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
        return $query->result();
    }

    function joinan23($nid)
    {
        $this->db->select('*');
        $this->db->from('tbl_gajiguru');
        //               $this->db->join('tbl_transaksi','tbl_transaksi.no_uangbangunan=tbl_siswa.no_uangbangunan'); 
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan'); 
        $this->db->where('nid =' . $nid);

        $query = $this->db->get();

        return $query->result();
    }

    function joinan24($nip)
    {
        $this->db->select('*');
        $this->db->from('tbl_gajistaf');
        //               $this->db->join('tbl_transaksi','tbl_transaksi.no_uangbangunan=tbl_siswa.no_uangbangunan'); 
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan'); 
        $this->db->where('nip =' . $nip);

        $query = $this->db->get();

        return $query->result();
    }

    function datajoin()
    {
        $this->db->from('tbl_transaksi');
        $this->db->join('tbl_siswa', 'tbl_siswa.kd_siswa=tbl_transaksi.kd_siswa');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_transaksi=tbl_pembayaran.kd_transaksi'); 

        $this->db->like('nama_siswa');
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);





            return $query->result();
        }
    }

    function datajoin2()
    {
        $this->db->from('tbl_pembayaran');
        $this->db->join('tbl_siswa', 'tbl_siswa.kd_siswa=tbl_pembayaran.kd_siswa');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_transaksi=tbl_pembayaran.kd_transaksi'); 

        $this->db->like('nama_siswa');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('options', $row->options);





            return $query->result();
        }
    }

    function get_produk($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.kd_pembayaran=tbl_siswa.kd_pembayaran');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_pembayaran', 'tbl_pembayaran.kd_pembayaran=tbl_pembayaran.kd_pembayaran');
        $this->db->where('kd_transaksi =' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_produk3()
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->join('tbl_pembayaran', 'tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');

        $query = $this->db->get();
        return $query;
    }

    function get_produk2($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        $this->db->where('kd_transaksi =' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksikaos($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $this->db->join('tbl_uang_kaosolahraga', 'tbl_uang_kaosolahraga.uang_kaos_olahraga=tbl_siswa.uang_kaos_olahraga');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiBatik($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_gamis=tbl_siswa.uang_gamis');
        $this->db->join('tbl_uang_gamis', 'tbl_uang_gamis.uang_gamis=tbl_siswa.uang_gamis');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiAlmameter($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kitab=tbl_siswa.uang_kitab');
        $this->db->join('tbl_uang_kitab', 'tbl_uang_kitab.uang_kitab=tbl_siswa.uang_kitab');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiUjian($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_ujian=tbl_siswa.uang_ujian');
        $this->db->join('tbl_uang_ujian', 'tbl_uang_ujian.uang_ujian=tbl_siswa.uang_ujian');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiPrakerin($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_prakerin=tbl_siswa.uang_prakerin');
        $this->db->join('tbl_uang_prakerin', 'tbl_uang_prakerin.uang_prakerin=tbl_siswa.uang_prakerin');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiSeragamSklh($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $this->db->join('tbl_uang_seragam_sklh', 'tbl_uang_seragam_sklh.uang_seragam_sklh=tbl_siswa.uang_seragam_sklh');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiZiarah($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_ziarah=tbl_siswa.uang_ziarah');
        $this->db->join('tbl_uang_ziarah', 'tbl_uang_ziarah.uang_ziarah=tbl_siswa.uang_ziarah');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_transaksiPekan($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_pekan=tbl_siswa.uang_pekan');
        $this->db->join('tbl_uang_pekan', 'tbl_uang_pekan.uang_pekan=tbl_siswa.uang_pekan');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_produk4($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_gajiguru');
        $this->db->join('tbl_guru', 'tbl_guru.nid=tbl_gajiguru.nid');
        $this->db->join('tbl_kasbon_guru', 'tbl_kasbon_guru.nid=tbl_gajiguru.nid');
        $this->db->where('kd =' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    function get_produk5($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_gajistaf');
        $this->db->join('tbl_stafbawah', 'tbl_stafbawah.nip=tbl_gajistaf.nip');
        $this->db->join('tbl_kasbon_staf', 'tbl_kasbon_staf.nip=tbl_gajistaf.nip');
        $this->db->join('tbl_master_stafbawah', 'tbl_master_stafbawah.kd_stafbawah=tbl_stafbawah.kd_stafbawah');
        $query = $this->db->get();
        return $query;
    }

    function jumlahsiswa()
    {
        $query = $this->db->get('tbl_siswa');
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function jumlahstaf()
    {
        $query = $this->db->get('tbl_staf');
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function jumlahstafbawah()
    {
        $query = $this->db->get('tbl_stafbawah');
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function jumlahguru()
    {
        $query = $this->db->get('tbl_guru');
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function jumlahsp()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->where('status_kenakalan=', 3);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function jumlahberkasiswa()
    {
        $this->db->select('*');
        $this->db->from('tbl_berkassiswa');
        $this->db->where('status_berkassiswa=', 0);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }



    function jumlahberkas2()
    {
        $this->db->select('*');
        $this->db->from('tbl_berkasguru');
        $this->db->where('keterangan=', 0);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function replaceM2($hari)
    {
        switch ($hari) {
            case "1":
                return "Januari";
                break;
            case "2":
                return "Februari";
                break;
            case "3":
                return "Maret";
                break;
            case "4":
                return "April";
                break;
            case "5":
                return "Mei";
                break;
            case "6":
                return "Juni";
                break;
            case "7":
                return "Juli";
                break;
            case "8":
                return "Agustus";
                break;
            case "9":
                return "September";
                break;
            case "10":
                return "Oktober";
                break;
            case "11":
                return "November";
                break;
            case "12":
                return "Desember";
                break;
            default:
                break;
        }
    }

    function replaceDay($hariEng)
    {
        switch ($hariEng) {
            case "Mon":
                return "Senin";
                break;
            case "Tue":
                return "Selasa";
                break;
            case "Wed":
                return "Rabu";
                break;
            case "Thu":
                return "Kamis";
                break;
            case "Fri":
                return "Jum'at";
                break;
            case "Sat":
                return "Sabtu";
                break;
            case "Sun":
                return "Minggu";
                break;
            default:
                return $hariEng;
                break;
        }
    }

    function replaceDay2($hariEng)
    {
        switch ($hariEng) {
            case "Mon":
                return "1";
                break;
            case "Tue":
                return "2";
                break;
            case "Wed":
                return "3";
                break;
            case "Thu":
                return "4";
                break;
            case "Fri":
                return "5";
                break;
            case "Sat":
                return "6";
                break;
            case "Sun":
                return "7";
                break;
            default:
                return $hariEng;
                break;
        }
    }

    function replaceDay3($hariEng)
    {
        switch ($hariEng) {
            case "Mon":
                return "Sen";
                break;
            case "Tue":
                return "Sel";
                break;
            case "Wed":
                return "Rab";
                break;
            case "Thu":
                return "Kam";
                break;
            case "Fri":
                return "Jum";
                break;
            case "Sat":
                return "Sab";
                break;
            case "Sun":
                return "Ming";
                break;
            default:
                return $hariEng;
                break;
        }
    }

    function GetJadwalBell($day)
    {
        $this->db->select('*');
        $this->db->from('resume');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=resume.id_hari');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $this->db->where('id_hari =' . $day);

        $query = $this->db->get();
        return $query->result();
    }

    function jadwalabsen($day)
    {
        $this->db->select('*');
        $this->db->from('tbl_absenguru');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_absenguru.id_hari');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $this->db->where('id_hari =' . $day);

        $query = $this->db->get();
        return $query->result();
    }

    function GetJadwalBell2($day)
    {
        $this->db->select('*');
        $this->db->from('resume');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=resume.id_hari');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $this->db->where('id_hari =' . $day);

        $query = $this->db->get();
        return $query->result_array();
    }

    function GetBunyiBell($day)
    {
        $this->db->select('*');
        $this->db->from('resume');
        $this->db->join('audio', 'audio.kd_audio=resume.id_audio');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $this->db->where('id_audio =' . $day);

        $query = $this->db->get();
        return $query;
    }


    function GetResmumeJoin()
    {


        $this->db->select('*');
        $this->db->from('resume');
        $this->db->join('audio', 'audio.kd_audio=resume.id_audio');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=resume.id_hari');



        $query = $this->db->get();
        return $query->result();
    }

    function joinkasbon()
    {
        $this->db->select('*');
        $this->db->from('tbl_kasbon_guru');
        $this->db->join('tbl_guru', 'tbl_guru.nid=tbl_kasbon_guru.nid');




        $query = $this->db->get();
        return $query->result();
    }

    function joinkasbon2()
    {
        $this->db->select('*');
        $this->db->from('tbl_kasbon_staf');

        $this->db->join('tbl_staf', 'tbl_staf.nis_staf=tbl_kasbon_staf.nis_staf');
        // $this->db->join('tbl_staf','tbl_staf.nis_staf=tbl_kasbon_staf.nis_staf');




        $query = $this->db->get();
        return $query->result();
    }

    function joinkasbon3()
    {
        $this->db->select('*');
        $this->db->from('tbl_kasbon_staf');

        $this->db->join('tbl_stafbawah', 'tbl_stafbawah.nip=tbl_kasbon_staf.nip');
        // $this->db->join('tbl_staf','tbl_staf.nis_staf=tbl_kasbon_staf.nis_staf');




        $query = $this->db->get();
        return $query->result();
    }

    function joinankasbon($kd)
    {

        $this->db->select('*');
        $this->db->from('tbl_kasbon_guru');
        // $this->db->join('tbl_guru','tbl_guru.kd_guru=tbl_kasbon_guru.kd_guru');



        $this->db->where('nid =' . $kd);
        $this->db->where('status_bayar', 0);
        $query = $this->db->get();
        return $query->result();
    }

    function joinankasbonstaf($kd)
    {

        $this->db->select('*');
        $this->db->from('tbl_kasbon_staf');
        // $this->db->join('tbl_guru','tbl_guru.kd_guru=tbl_kasbon_guru.kd_guru');



        $this->db->where('nip =' . $kd);
        $this->db->where('nis_staf=' . $kd);
        $this->db->where('status_bayar', 0);
        $query = $this->db->get();
        return $query->result();
    }

    function joinankasbonkepsek($kd)
    {

        $this->db->select('*');
        $this->db->from('tbl_kasbon_staf');
        $this->db->where('nis_staf=' . $kd);
        $this->db->where('status_bayar', 0);
        $query = $this->db->get();
        return $query->result();
    }



    function hitungpengeluaran()
    {

        $this->db->select_sum('status_siswa');
        $query = $this->db->get('tbl_siswa');
        if ($query->num_rows() > 0) {
            return $query->row()->status_siswa;
        } else {
            return 0;
        }
    }

    function hitungpemasukantabungan()
    {

        $this->db->select_sum('jml_nabung');
        $query = $this->db->get('tbl_tabungansiswa');
        if ($query->num_rows() > 0) {
            return $query->row()->jml_nabung;
        } else {
            return 0;
        }
    }

    function totalsudahbayarSPP()
    {
        $bulan = $this->MSudi->replacebulan(date('m'));
        $this->db->select('options, count(*)');
        $this->db->where('options', 'L');
        $this->db->where('bulan', $bulan);
        // $query = $this->db->get('tbl_pembayaran');
        return $this->db->count_all_results('tbl_pembayaran');
    }



    function getjadwal($day)
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        // $this->db->where('id_hari ='.$day);
        $this->db->where('nid =' . $this->session->userdata('ses_nid'));
        $this->db->where('id_hari=' . $day);
        $query = $this->db->get();
        return $query->result();
    }

    function getmonitoringabsen($day)
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nid ='.$this->session->userdata('ses_nid'));
        $this->db->where('id_hari=' . $day);
        $query = $this->db->get();
        return $query->result();
    }

    function getjadwal3($kd)
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nid ='.$this->session->userdata('ses_nid'));
        $this->db->where('nid=' . $kd);
        $query = $this->db->get();
        return $query->result();
    }

    function getjadwal5()
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nid ='.$this->session->userdata('ses_nid'));
        // $this->db->where('nid='. $kd);
        $query = $this->db->get();
        return $query->result();
    }

    function getjadwal4()
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        $this->db->join('tbl_guru', 'tbl_guru.nid=tbl_jadwal_pelajaran2.nid');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nid ='.$this->session->userdata('ses_nid'));
        // $this->db->where('id_hari='. $day);
        $query = $this->db->get();
        return $query->result();
    }

    function getjadwal2()
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwalabsen');

        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nid ='.$this->session->userdata('ses_id'));

        $query = $this->db->get();
        return $query->result();
    }

    function getjoinstatus()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('nama_guru ='.$this->session->userdata('ses_nid'));

        $query = $this->db->get();
        return $query;
    }

    function getjoinstatus2()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_bangunan', 'tbl_uang_bangunan.no_uangbangunan=tbl_siswa.no_uangbangunan');
        // $this->db->join('tbl_pembayaran','tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('keterangan =', 1);

        $query = $this->db->get();
        return $query->result();
    }

    function jointabsiswa()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_tabungansiswa', 'tbl_tabungansiswa.nis=tbl_siswa.nis', 'left');

        // $this->db->join('tbl_pembayaran','tbl_pembayaran.kd_pembayaran=tbl_siswa.kd_pembayaran');
        // $this->db->where('id_hari ='.$day);
        // $this->db->where('keterangan =', 1);

        $query = $this->db->get();
        return $query->result();
    }


    function getjadwalmengajar($day)
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_guru', 'tbl_guru.nid=tbl_jadwal_pelajaran2.nid');

        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $this->db->where('kd=' . $day);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kelasGuru', $row->kelas_guru);
            return $query;
        }
        return $query;
    }

    function getkelasajar($nid)
    {
        $this->db->select('*');
        $this->db->from('tbl_guru');
        $this->db->where('nid =' . $nid);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kelasGuru', $row->kelas_guru);
            return $query;
        }
        return $query;
    }

    function getjadwalmengajar2()
    {
        $this->db->select('*');
        $this->db->from('tbl_jadwal_pelajaran2');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=tbl_jadwal_pelajaran2.id_hari');
        $this->db->join('tbl_mapel', 'tbl_mapel.kd_mapel=tbl_jadwal_pelajaran2.kd_mapel');
        $this->db->join('tbl_guru', 'tbl_guru.nid=tbl_jadwal_pelajaran2.nid');

        // $this->db->join('tbl_uang_bangunan','tbl_uang_bangunan.no_uangbangunan=resume.no_uangbangunan');
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kelasGuru', $row->kelas_guru);

            return $query;
        }
        return $query->result();
    }

    function joindata1($kd)
    {
        $this->db->select('*');
        $this->db->from('tbl_guru');
        $this->db->join('tbl_master_penggajian', 'tbl_master_penggajian.kd_penggajian=tbl_guru.kd_penggajian');
        $this->db->where('kd_guru=' . $kd);
        $query = $this->db->get();
        return $query;
    }

    function joindata3($kd)
    {
        $this->db->select('*');
        $this->db->from('tbl_guru');
        $this->db->join('tbl_master_penggajian', 'tbl_master_penggajian.kd_penggajian=tbl_guru.kd_penggajian');
        $this->db->join('tbl_master_jabatan', 'tbl_master_jabatan.kd_jabatan=tbl_guru.kd_jabatan');
        $this->db->where('nid=' . $kd);
        $query = $this->db->get();
        return $query;
    }

    function joindata5($kd)
    {
        $this->db->select('*');
        $this->db->from('tbl_stafbawah');
        $this->db->join('tbl_master_stafbawah', 'tbl_master_stafbawah.kd_stafbawah=tbl_stafbawah.kd_stafbawah');
        // $this->db->join('tbl_kasbon_staf','tbl_kasbon_staf.kd_kasbon=tbl_stafbawah.kd_kasbon'); 
        $this->db->where('nip=' . $kd);
        $query = $this->db->get();
        return $query;
    }

    function jabatan()
    {
        $this->db->select('*');
        $this->db->from('tbl_guru');

        $this->db->join('tbl_master_jabatan', 'tbl_master_jabatan.kd_jabatan=tbl_guru.kd_jabatan');

        $query = $this->db->get();
        return $query;
    }

    function joindata2()
    {
        $this->db->select('*');
        $this->db->from('tbl_guru');
        $this->db->join('tbl_master_penggajian', 'tbl_master_penggajian.kd_penggajian=tbl_guru.kd_penggajian');

        $query = $this->db->get();
        return $query->result();
    }

    function joindata4()
    {
        $this->db->select('*');
        $this->db->from('tbl_stafbawah');
        $this->db->join('tbl_master_stafbawah', 'tbl_master_stafbawah.kd_stafbawah=tbl_stafbawah.kd_stafbawah');

        $query = $this->db->get();
        return $query->result();
    }

    function hitungjumlahpoin($kd)
    {

        $this->db->select_sum('poin_kenakalan');
        $this->db->where('nis =' . $kd);

        $query = $this->db->get('tbl_poinsiswa');
        if ($query->num_rows() > 0) {
            return $query->row()->poin_kenakalan;
        } else {
            return 0;
        }
    }

    function datakenakalan($kd)
    {

        $this->db->select('*');
        $this->db->from('tbl_poinsiswa');
        $this->db->where('nis =' . $kd);

        $query = $this->db->get();
        return $query->result();
    }

    function totalspp()
    {

        $this->db->select_sum('jml_pembayaran');
        $this->db->where('kategori_trans', 'SPP');

        $query = $this->db->get('tbl_transaksi');
        if ($query->num_rows() > 0) {
            return $query->row()->jml_pembayaran;
        } else {
            return 0;
        }
    }

    function totalUB()
    {

        $this->db->select_sum('jml_pembayaran');
        $this->db->where('kategori_trans', 'UB');

        $query = $this->db->get('tbl_transaksi');
        if ($query->num_rows() > 0) {
            return $query->row()->jml_pembayaran;
        } else {
            return 0;
        }
    }

    function totalgajiguru()
    {

        $this->db->select_sum('total_gaji');


        $query = $this->db->get('tbl_gajiguru');
        if ($query->num_rows() > 0) {
            return $query->row()->total_gaji;
        } else {
            return 0;
        }
    }

    function akumulasiabsen($kd)
    {

        $this->db->select_sum('kehadiran');
        $this->db->where('nid=' . $kd);

        $query = $this->db->get('tbl_kehadiran');
        if ($query->num_rows() > 0) {
            return $query->row()->kehadiran;
        } else {
            return 0;
        }
    }

    function akumulasiabsen2($kd)
    {

        $this->db->select_sum('kehadiran');
        $this->db->where('nip=' . $kd);

        $query = $this->db->get('tbl_kehadiranstaf');
        if ($query->num_rows() > 0) {
            return $query->row()->kehadiran;
        } else {
            return 0;
        }
    }



    function joinankasbon2($kd)
    {

        $this->db->select_sum('jml_kasbon');
        $this->db->from('tbl_kasbon_guru');
        // $this->db->join('tbl_guru','tbl_guru.nid=tbl_kasbon_guru.nid');
        $this->db->where('nid=' . $kd);
        $this->db->where('status_bayar', 0);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->jml_kasbon;
        } else {
            return 0;
        }
    }

    function joinankasbon3($kd)
    {

        $this->db->select_sum('jml_kasbon');
        $this->db->from('tbl_kasbon_staf');
        // $this->db->join('tbl_guru','tbl_guru.nid=tbl_kasbon_guru.nid');
        $this->db->where('nip=' . $kd);
        $this->db->where('status_bayar', 0);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->jml_kasbon;
        } else {
            return 0;
        }
    }

    function getpengspp($kd)
    {

        $this->db->select_sum('total_gaji');
        $this->db->from('tbl_gajiguru');
        // $this->db->join('tbl_guru','tbl_guru.nid=tbl_kasbon_guru.nid');
        $this->db->where('tanggal=' . $kd);

        $query = $this->db->get();

        // $query = $this->db->query("SELECT total_gaji, SUM(total_gaji) FROM `tbl_gajiguru` WHERE tgl_gaji ='$kd'");

        if ($query->num_rows() > 0) {
            return $query->row()->total_gaji;
        } else {
            return 0;
        }
    }

    function getdataspp()
    {

        $this->db->select('tgl_gaji');
        $this->db->distinct('tgl_gaji');


        $this->db->select('tanggal');
        $this->db->distinct('tanggal');
        $this->db->from('tbl_gajiguru');

        $query = $this->db->get();
        return $query->result();
        // $this->db->join('tbl_guru','tbl_guru.nid=tbl_kasbon_guru.nid');

    }

    function joinptgTab($nis)
    {

        $this->db->select('*');
        $this->db->from('tbl_tabungansiswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_tabungansiswa.no_administrasi');
        $this->db->where('nis=' . $nis);
        $query = $this->db->get();
        return $query;
    }

    function dataTransaksiSantri($nis)
    {

        $this->db->select('*');
        $this->db->from('transaksi_tfsantri');
        $this->db->join('tbl_tabungansiswa', 'tbl_tabungansiswa.kd=transaksi_tfsantri.kd_tabungan');
        $this->db->join('tbl_siswa', 'tbl_siswa.nis=transaksi_tfsantri.nis');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=transaksi_tfsantri.id_hari');
        $this->db->where('id_hari=' . $nis);
        $this->db->where('nisn=' . $this->session->userdata('ses_nisn'));

        // $this->db->where('id_hari='.$nis);
        $query = $this->db->get();
        return $query->result();
    }

    function dataTransaksiSantri2($nis)
    {

        $this->db->select('*');
        $this->db->from('transaksi_tfsantri');
        $this->db->join('tbl_tabungansiswa', 'tbl_tabungansiswa.kd=transaksi_tfsantri.kd_tabungan');
        $this->db->join('tbl_siswa', 'tbl_siswa.nis=transaksi_tfsantri.nis');
        $this->db->join('tbl_hari', 'tbl_hari.kd_hari=transaksi_tfsantri.id_hari');
        $this->db->where('tgl_transaksi', $nis);
        // $this->db->where('nisn='.$this->session->userdata('ses_nisn'));

        // $this->db->where('id_hari='.$nis);
        $query = $this->db->get();
        return $query->result();
    }

    function joinreqsantri()
    {

        $this->db->select('*');
        $this->db->from('tbl_penarikansantri');
        $this->db->join('tbl_siswa', 'tbl_siswa.nis=tbl_penarikansantri.nis');
        // $this->db->join('tbl_siswa','tbl_siswa.nis=transaksi_tfsantri.nis');
        //  $this->db->join('tbl_hari','tbl_hari.kd_hari=transaksi_tfsantri.id_hari');
        $this->db->where('status', 0);
        // $this->db->where('nisn='.$this->session->userdata('ses_nisn'));

        // $this->db->where('id_hari='.$nis);
        $query = $this->db->get();
        return $query->result();
    }

    function dataTransaksiInfaq($nis)
    {

        $this->db->select('*');
        $this->db->from('riwayatinfaq');
        // $this->db->join('tbl_tabungansiswa','tbl_tabungansiswa.kd=riwayat_infaq.kd_tabungan');
        // $this->db->join('tbl_siswa','tbl_siswa.nis=riwayat_infaq.nis');
        //  $this->db->join('tbl_hari','tbl_hari.kd_hari=riwayat_infaq.id_hari');
        // $this->db->where('id_hari='.$nis);
        $this->db->where('nis=' . $this->session->userdata('ses_id'));

        // $this->db->where('id_hari='.$nis);
        $query = $this->db->get();
        return $query->result();
    }

    function joindatatf($username)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_tabungansiswa', 'tbl_tabungansiswa.kd=tbl_siswa.kd_tabungan');
        $this->db->where('nisn=' . $username);
        $this->db->limit(1);


        $query = $this->db->get();
        // $this->db->query("SELECT * FROM tbl_siswa WHERE nis='$username' AND nis='$password' LIMIT 1");
        return $query;
    }

    function hitungPemasukan()
    {

        $day = date("Y-m-d");
        $this->db->select_sum('harga_satuan');
        $this->db->where('tgl_transaksi', $day);
        $query = $this->db->get('tbl_riwayattrans2');
        if ($query->num_rows() > 0) {
            return $query->row()->harga_satuan;
        } else {
            return 0;
        }
    }

    function tampil_data()
    {
        return $this->db->get('tbl_siswa');
    }

    function cari($id)
    {
        $query = $this->db->get_where('tbl_siswa', array('nis' => $id));

        return $query;
    }

    function cari2($id)
    {

        $this->db->select('*');
        $this->db->from('tbl_barang');
        $this->db->where('kode_barang', $id);
        // $this->db->where('id_pedagang='.$this->session->userdata('ses_id'));

        $query = $this->db->get();
        return $query;
        // $query= $this->db->get_where('tbl_barang',array('kode_barang'=>$id, 'id_pedagang'=>$this->session->userdata('ses_nid')));

        // return $query;
    }

    ////////lemari//////////////////

    function Get20($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_lemari', 'tbl_uang_lemari.uang_lemari=tbl_siswa.uang_lemari');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }



    function DataJoinLemari($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_lemari=tbl_siswa.uang_lemari');
        $this->db->join('tbl_uang_lemari', 'tbl_uang_lemari.uang_lemari=tbl_siswa.uang_lemari');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);

            return $query->result();
        }
        return $query->result();
    }


    function joinanLemari($kd_siswa)
    {
        $this->db->from('tbl_uang_lemari');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_lemari=tbl_uang_lemari.uang_lemari');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function GetLemari()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_lemari', 'tbl_uang_lemari.uang_lemari=tbl_siswa.uang_lemari');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_lemari', $row->uang_lemari);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function get_transaksiLemari($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_lemari=tbl_siswa.uang_lemari');
        $this->db->join('tbl_uang_lemari', 'tbl_uang_lemari.uang_lemari=tbl_siswa.uang_lemari');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }


    //////////lemari/////////////

    ///////kesehatan/////////////////

    function Get21($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kesehatan', 'tbl_uang_kesehatan.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }


    function DataJoinKesehatan($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->join('tbl_uang_kesehatan', 'tbl_uang_kesehatan.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);




            return $query->result();
        }
        return $query->result();
    }


    function joinanKesehatan($kd_siswa)
    {
        $this->db->from('tbl_uang_kesehatan');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_kesehatan=tbl_uang_kesehatan.uang_kesehatan');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }


    function GetKesehatan()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kesehatan', 'tbl_uang_kesehatan.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_kesehatan', $row->uang_kesehatan);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function get_transaksiKesehatan($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->join('tbl_uang_kesehatan', 'tbl_uang_kesehatan.uang_kesehatan=tbl_siswa.uang_kesehatan');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    ///////////////kesehatan/////////////////


    /////////////formulir//////////////////////

    function Get22($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_formulir', 'tbl_uang_formulir.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }

    function DataJoinFormulir($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->join('tbl_uang_formulir', 'tbl_uang_formulir.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);




            return $query->result();
        }
        return $query->result();
    }



    function joinanFormulir($kd_siswa)
    {
        $this->db->from('tbl_uang_formulir');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_formulir=tbl_uang_formulir.uang_formulir');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }

    function GetFormulir()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_formulir', 'tbl_uang_formulir.uang_formulir=tbl_siswa.uang_formulir');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_formulir', $row->uang_formulir);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }

    function get_transaksiFormulir($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->join('tbl_uang_formulir', 'tbl_uang_formulir.uang_formulir=tbl_siswa.uang_formulir');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    /////////////formulir//////////////////////

    /////raport////////////////

    function Get23($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_raport', 'tbl_uang_raport.uang_raport=tbl_siswa.uang_raport');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }




    function DataJoinRaport($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_raport=tbl_siswa.uang_raport');
        $this->db->join('tbl_uang_raport', 'tbl_uang_raport.uang_raport=tbl_siswa.uang_raport');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);




            return $query->result();
        }
        return $query->result();
    }



    function joinanRaport($kd_siswa)
    {
        $this->db->from('tbl_uang_raport');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_raport=tbl_uang_raport.uang_raport');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }


    function GetRaport()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_raport', 'tbl_uang_raport.uang_raport=tbl_siswa.uang_raport');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_raport', $row->uang_raport);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }



    function get_transaksiRaport($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_raport=tbl_siswa.uang_raport');
        $this->db->join('tbl_uang_raport', 'tbl_uang_raport.uang_raport=tbl_siswa.uang_raport');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    /////raport///////////////////


    //////pramuka//////////

    function Get24($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }



    function DataJoinPramuka($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);




            return $query->result();
        }
        return $query->result();
    }


    function joinanPramuka($kd_siswa)
    {
        $this->db->from('tbl_uang_pramuka');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_pramuka=tbl_uang_pramuka.uang_pramuka');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }


    function GetPramuka()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_pramuka', $row->uang_lemari);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }



    function get_transaksiPramuka($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->join('tbl_uang_pramuka', 'tbl_uang_pramuka.uang_pramuka=tbl_siswa.uang_pramuka');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    /////pramuka///////////


    /////////kalender/////////

    function Get25($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kalender', 'tbl_uang_kalender.uang_kalender=tbl_siswa.uang_kalender');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query;
    }



    function DataJoinkalender($kd_siswa)
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kalender=tbl_siswa.uang_kalender');
        $this->db->join('tbl_uang_kalender', 'tbl_uang_kalender.uang_kalender=tbl_siswa.uang_kalender');
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $row = $query->row();
            $this->session->set_userdata('kd_transaksi', $row->kd_transaksi);




            return $query->result();
        }
        return $query->result();
    }


    function joinankalender($kd_siswa)
    {
        $this->db->from('tbl_uang_kalender');
        $this->db->join('tbl_siswa', 'tbl_siswa.uang_kalender=tbl_uang_kalender.uang_kalender');
        // $this->db->join('tbl_transaksi','tbl_transaksi.kd_siswa=tbl_pembayaran.kd_siswa'); 
        $this->db->where('kd_siswa =' . $kd_siswa);

        $query = $this->db->get();
        return $query->result();
    }


    function Getkalender()
    {
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_master_administrasi', 'tbl_master_administrasi.no_administrasi=tbl_siswa.no_administrasi');
        $this->db->join('tbl_uang_kalender', 'tbl_uang_kalender.uang_kalender=tbl_siswa.uang_kalender');
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            $row = $query->row();
            $this->session->set_userdata('uang_kalender', $row->uang_kalender);
            // $this->session->set_userdata('uangB', $row->uang_bangunan);
            $this->session->set_userdata('kd_siswa', $row->kd_siswa);
            return $query;
        }
        return $query->result();
    }



    function get_transaksikalender($kd_transaksi)
    {
        // $a= $this->session->userdata('kd_transaksi');
        $this->db->select('*');
        $this->db->from('tbl_siswa');
        $this->db->join('tbl_transaksi', 'tbl_transaksi.uang_kalender=tbl_siswa.uang_kalender');
        $this->db->join('tbl_uang_kalender', 'tbl_uang_kalender.uang_kalender=tbl_siswa.uang_kalender');
        $this->db->where('kd_transaksi=' . $kd_transaksi);
        $query = $this->db->get();
        return $query;
    }

    //////////kalender/////////

    function hitungstok()
    {

        $this->db->where('stok_barang', 0);
        $query = $this->db->get('tbl_barang');

        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
    }

    function tampil_detail($id)
    {
        $query = $this->db->query("SELECT 
        a.`nama_barang`,
        a.`harga_satuan`,
        SUM(a.`jumlah_beli`) AS jumlah
         FROM `tbl_riwayattrans2` a WHERE a.`id_trans` = '$id'
        GROUP BY a.`kode_barang`");
        return  $query->result_array();
    }

    function tampil_search()
    {

        $id = $this->session->userdata('ses_id');
        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("a.`id_trans`,
        b.`nama_siswa`,
        a.`total_harga`,
        a.`id_pedagang`,
        a.`tgl_transaksi`");
        $this->db->from('tbl_riwayattrans2 a');
        $this->db->join('tbl_siswa b', 'b.`nis`=a.`nis`');
        $this->db->where('a.id_pedagang', $id);

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            if (empty($tglakhir)) {
                $this->db->where('a.tgl_transaksi', $tglawal);
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_transaksi >=', $tglawal);
                $this->db->where('a.tgl_transaksi <=', $tglakhir);
            }
            $L    = true;
        }

        $this->db->group_by('a.id_trans', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function tampil_searchA()
    {

        $id = $this->session->userdata('ses_id');
        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("a.`id_trans`,
        b.`nama_siswa`,
        a.`total_harga`,
        a.`id_pedagang`,
        a.`tgl_transaksi`");
        $this->db->from('tbl_riwayattrans2 a');
        $this->db->join('tbl_siswa b', 'b.`nis`=a.`nis`');
        $this->db->where('a.id_pedagang', 1234567);

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            if (empty($tglakhir)) {
                $this->db->where('a.tgl_transaksi', $tglawal);
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_transaksi >=', $tglawal);
                $this->db->where('a.tgl_transaksi <=', $tglakhir);
            }
            $L    = true;
        }

        $this->db->group_by('a.id_trans', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function tampil_searchB()
    {

        $id = $this->session->userdata('ses_id');
        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("a.`id_trans`,
        b.`nama_siswa`,
        a.`total_harga`,
        a.`id_pedagang`,
        a.`tgl_transaksi`");
        $this->db->from('tbl_riwayattrans2 a');
        $this->db->join('tbl_siswa b', 'b.`nis`=a.`nis`');
        $this->db->where('a.id_pedagang', 909090);

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            if (empty($tglakhir)) {
                $this->db->where('a.tgl_transaksi', $tglawal);
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_transaksi >=', $tglawal);
                $this->db->where('a.tgl_transaksi <=', $tglakhir);
            }
            $L    = true;
        }

        $this->db->group_by('a.id_trans', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }
    public function no_form()
    {
        $query = $this->db->query('SELECT 
                                    RIGHT(a.`id`, 5) AS id_trans 
                                FROM
                                    `tbl_riwayattrans` a 
                                ORDER BY a.`id_trans` DESC 
                                LIMIT 1 ');
        //cek dulu apakah ada sudah ada kode di tabel.   

        if ($query->num_rows() <> 0) {
            //cek kode jika telah tersedia    
            $data = $query->row();
            $kode = intval($data->id_trans) + 1;
        } else {

            $kode = 1;  //cek jika kode belum terdapat pada table
        }

        //   $dpt= $this->session->userdata('user_kd_dpt');

        $tm =  date("mY");


        $batas = str_pad($kode, 4, "0", STR_PAD_LEFT);
        $kodetampil = $batas . "-" . "TR" . "-" . $tm;  //format kode
        return $kodetampil;
    }

    //////////////////////////////////////////infaq//////////////////////////////////////////////////////////////
    function search_infaq()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                            a.`nis`,
                            a.`nama`,
                            a.`tipe_infaq`,
                            a.`jml_infaq`,
                            DATE(a.`tgl_infaq`) AS waktu");
        $this->db->from('riwayatinfaq a');
        $L    = false;
        $search    = [];



        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }


        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.tgl_infaq', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_infaq >=', $tglawal);
                $this->db->where('a.tgl_infaq <=', $tglakhir);
                $L    = true;
            }

            //Search By status
            if (!empty($kat)) {
                if ($kat == 'PHBI') {
                    $this->db->where('a.tipe_infaq', 'PHBI');
                } else if ($kat == 'SOSIAL') {
                    $this->db->where('a.tipe_infaq', 'SOSIAL');
                } else if ($kat == '1') {
                    $this->db->where('a.tipe_infaq', NULL, TRUE);
                }

                $L    = true;
            }
        }


        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function saldoInfaq()
    {
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`tipe` = 'INFAQ'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }

    function saldoAdm()
    {
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`id` = '5'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }

    function PengeluaranInfaq()
    {
        $query = $this->db->query("SELECT SUM(d.`dana`) AS total FROM tbl_pengeluaran_infaq d");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }


    function KeluaranDenda()
    {
        $query = $this->db->query("SELECT SUM(d.`dana`) AS total FROM tbl_pengeluaran_denda d");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PemasukanInfaq()
    {
        $query = $this->db->query("SELECT SUM(d.`jml_infaq`) AS total FROM riwayatinfaq d");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }


    //////////////////////////////////////////infaq//////////////////////////////////////////////////////////////

    //////////////////////////////////////////infaq//////////////////////////////////////////////////////////////
    function saldoDendacek()
    {
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`tipe` = 'DENDA'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }

    function PemasukanDenda()
    {
        $query = $this->db->query("SELECT SUM(d.`jumlah_denda`) AS total FROM tbl_denda d");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PengeluaranDenda()
    {
        $query = $this->db->query("SELECT SUM(d.`jumlah_denda`) AS total FROM tbl_denda d");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    //////////////////////////////////////////infaq//////////////////////////////////////////////////////////////

    function tampil_siswa()
    {
        $this->db->select("a.`kd_siswa`,a.`nis`,a.`nama_siswa`");
        $this->db->from('tbl_siswa a');
        $this->db->order_by("a.`kd_siswa`, 'DESC'");
        $query = $this->db->get();
        return $query->result_array();
    }

    function tampil_pedagang()
    {
        $query = $this->db->query("SELECT 
                a.`nis_staf`,
                a.`nama_staf`,
                a.`level_akses` 
            FROM
                `tbl_staf` a 
            WHERE a.`level_akses` = '5' ");
        return $query->result_array();
    }

    function search_transfer()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                    a.`nis` AS nis_pengirim ,
                    b.`nama_siswa` AS nama_siswa,
                    a.`nis_penerima` AS nis_penerima,
                    a.`nama_penerima` AS nama_penerima,
                    a.`jml_transfer` AS jml_transfer,
                    a.`tgl_transaksi` AS tgl_transaksi");
        $this->db->from('transaksi_tfsantri a');
        $this->db->join('tbl_siswa b', 'b.nis=a.nis');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.tgl_transaksi', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_transaksi >=', $tglawal);
                $this->db->where('a.tgl_transaksi <=', $tglakhir);
                $L    = true;
            }

            //Search By siswa
            if (!empty($siswa)) {
                $this->db->where('a.nis', $siswa);
                $L    = true;
            } else if (empty($siswa)) {
                $L    = true;
            }
        }

        $this->db->group_by('a.kd_transaksi', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function search_saldo()
    {
        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                a.`nis`,
                b.`nama_siswa`,
                a.`jml_pendapatan`,
                a.`tgl_pendapatan`,
                a.`jenis`");
        $this->db->from('tbl_pendapatan_tabungan a');
        $this->db->join('tbl_siswa b', 'b.nis=a.nis');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.tgl_pendapatan', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tgl_pendapatan >=', $tglawal);
                $this->db->where('a.tgl_pendapatan <=', $tglakhir);
                $L    = true;
            }

            //Search By siswa
            if (!empty($siswa)) {
                $this->db->where('a.nis', $siswa);
                $L    = true;
            } else if (empty($siswa)) {
                $L    = true;
            }
        }

        $this->db->group_by('a.kd_pendapatan', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function search_pendapatan()
    {

        $return    = null;
        $this->db->select("*");
        $this->db->from('tbl_penarikanuang a');
        // $this->db->join('tbl_siswa','tbl_siswa.nis=A.nis');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            //Search By siswa
            if (!empty($pedagang)) {
                $this->db->where('a.id_pedagang', $pedagang);
                $L    = true;
            } else if (empty($pedagang)) {
                $L    = true;
            }
        }

        $this->db->group_by('a.kd', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function tampil_biayaadmin()
    {
        $this->db->select("*");
        $this->db->from('tbl_data a');
        $this->db->order_by("a.`kd`, 'DESC'");
        $query = $this->db->get();
        return $query->result_array();
    }

    function hitungSaldoToko()
    {
        // $this->db->select_sum('total_penarikan');
        $query = $this->db->query("SELECT SUM(a.`total_penarikan`) AS total_pen FROM tbl_penarikanuang a");
        if ($query->num_rows() > 0) {
            return $query->row()->total_pen;
        } else {
            return 0;
        }
    }

    function pj_kemarinA()
    {
        $kemarin = date('Y-m-d', strtotime("-1 day", strtotime(date("Y-m-d"))));
        $query = $this->db->query("SELECT SUM(b.`total_penarikan`) AS kemarin FROM tbl_penarikanuang b WHERE b.`tanggal_pengajuan` = '$kemarin'
         AND b.`id_pedagang` = '1234567'");
        if ($query->num_rows() > 0) {
            return $query->row()->kemarin;
        } else {
            return 0;
        }
    }


    function pj_kemarinB()
    {
        $kemarin = date('Y-m-d', strtotime("-1 day", strtotime(date("Y-m-d"))));
        $query = $this->db->query("SELECT SUM(b.`total_penarikan`) AS kemarin FROM tbl_penarikanuang b WHERE b.`tanggal_pengajuan` = '$kemarin' AND b.`id_pedagang` = '909090'");
        if ($query->num_rows() > 0) {
            return $query->row()->kemarin;
        } else {
            return 0;
        }
    }



    function hitungPendapatanToko()
    {
        $id = $this->session->userdata('ses_id');
        $day = date("Y-m-d");
        $query = $this->db->query(" SELECT 
        SUM(
            a.`harga_satuan` * a.`jumlah_beli`
        ) AS total 
        FROM
        `tbl_riwayattrans` a 
        WHERE a.`tgl_transaksi` = '$day' AND a.`id_pedagang` = '$id'");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }


    function hitungPendapatanBersih()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT 
        SUM(a.`total_penarikan`) AS total 
        FROM
        `tbl_penarikanuang` a 
        WHERE a.`tanggal_pengajuan` = $day ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PendapatanTokoB()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`total_penarikan`) AS total FROM
        `tbl_penarikanuang` a 
        WHERE a.`tanggal_pengajuan` = '$day' AND a.`id_pedagang` = '909090' ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }


    function PendapatanTokoA()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`total_penarikan`) AS total FROM
        `tbl_penarikanuang` a 
        WHERE a.`tanggal_pengajuan` = '$day' AND a.`id_pedagang` = '1234567' ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function hitungJmlSaldo()
    {
        $query = $this->db->query("SELECT SUM(a.`jml_pendapatan`)  AS saldo FROM tbl_pendapatan_tabungan a");
        if ($query->num_rows() > 0) {
            return $query->row()->saldo;
        } else {
            return 0;
        }
    }




    function hitungJmlSaldo_tabungan()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query(" SELECT a.`jumlah` FROM `tbl_tabungan_tahunan` a WHERE a.`nis` = '$nis'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah;
        } else {
            return 0;
        }
    }


    function saldoHarian()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`jml_pendapatan`)  AS saldo_harian FROM tbl_pendapatan_tabungan a WHERE a.`tgl_pendapatan` = '$day'");
        if ($query->num_rows() > 0) {
            return $query->row()->saldo_harian;
        } else {
            return 0;
        }
    }


    function SaldoKemarin()
    {
        $kemarin = date('Y-m-d', strtotime("-1 day", strtotime(date("Y-m-d"))));
        $query = $this->db->query("SELECT SUM(b.`jml_pendapatan`) AS saldo_kemarin FROM tbl_pendapatan_tabungan b WHERE b.`tgl_pendapatan` = '$kemarin'");
        if ($query->num_rows() > 0) {
            return $query->row()->saldo_kemarin;
        } else {
            return 0;
        }
    }

    function BiayaAdmin()
    {
        $query = $this->db->query("SELECT SUM(d.`isi_data`) AS biaya_admin FROM tbl_data d WHERE d.`ket_data` = 'Biaya Admin'");
        if ($query->num_rows() > 0) {
            return $query->row()->biaya_admin;
        } else {
            return 0;
        }
    }

    function BiayaKomisi()
    {
        $query = $this->db->query("SELECT SUM(d.`isi_data`) AS biaya_komisi FROM tbl_data d WHERE d.`ket_data` = 'Biaya Komisi Toko'");
        if ($query->num_rows() > 0) {
            return $query->row()->biaya_komisi;
        } else {
            return 0;
        }
    }


    function totaltabungan_thn()
    {
        $query = $this->db->query("SELECT SUM(d.`total`) AS jml FROM tbl_tabungan_tahunan d");
        if ($query->num_rows() > 0) {
            return $query->row()->jml;
        } else {
            return 0;
        }
    }


    function Pengeluaranhari()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`dana`) AS total FROM  tbl_pengeluaran_toko a WHERE  a.`tipe` = '1234567' ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PengeluaranhariB()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`dana`) AS total FROM  tbl_pengeluaran_toko_b a  ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PengeluaranhariKemarin()
    {
        $kemarin = date('Y-m-d', strtotime("-1 day", strtotime(date("Y-m-d"))));
        $query = $this->db->query("SELECT SUM(b.`dana`) AS keluar_kemarin FROM tbl_pengeluaran_toko b WHERE b.`dibuat` = '$kemarin' AND b.`tipe` = 'TOKO'");
        if ($query->num_rows() > 0) {
            return $query->row()->keluar_kemarin;
        } else {
            return 0;
        }
    }

    // function PengeluaranhariADM()
    // {
    //     $day = date("Y-m-d");
    //     $query = $this->db->query("SELECT SUM(a.`dana`) AS total FROM  tbl_pengeluaran_toko a WHERE a.`dibuat` = '$day' AND a.`tipe` = 'ADM' ");
    //     if ($query->num_rows() > 0) {
    //         return $query->row()->total;
    //     } else {
    //         return 0;
    //     }
    // }

    function PengeluaraAdm()
    {
        $day = date("Y-m-d");
        $query = $this->db->query("SELECT SUM(a.`dana`) AS total FROM  tbl_pengeluaran_adm a ");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function PengeluaranhariKemarinADM()
    {
        $kemarin = date('Y-m-d', strtotime("-1 day", strtotime(date("Y-m-d"))));
        $query = $this->db->query("SELECT SUM(b.`dana`) AS keluar_kemarin FROM tbl_pengeluaran_toko b WHERE b.`dibuat` = '$kemarin' AND b.`tipe` = 'ADM'");
        if ($query->num_rows() > 0) {
            return $query->row()->keluar_kemarin;
        } else {
            return 0;
        }
    }

    // function toko()
    // {

    //     $this->db->select('*');
    //     $this->db->from('tbl_penarikanuang');
    //     $query = $this->db->get();
    //     return $query->result_array();

    // }

    function toko_search()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                a.`nama_pedagang`,
                a.`total_penarikan`,
                a.`id_pedagang`,
                a.`tanggal_pengajuan` ");
        $this->db->from('tbl_penarikanuang a');
        $this->db->where('a.id_pedagang', '1234567');
        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.tanggal_pengajuan', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tanggal_pengajuan >=', $tglawal);
                $this->db->where('a.tanggal_pengajuan <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function toko_searchB()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                a.`nama_pedagang`,
                a.`total_penarikan`,
                a.`id_pedagang`,
                a.`tanggal_pengajuan` ");
        $this->db->from('tbl_penarikanuang a');
        $this->db->where('a.id_pedagang', '909090');
        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.tanggal_pengajuan', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.tanggal_pengajuan >=', $tglawal);
                $this->db->where('a.tanggal_pengajuan <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function Pengeluaran()
    {
        $query = $this->db->query("SELECT * FROM `tbl_pengeluaran_toko` a WHERE a.tipe = 'TOKO'");
        return $query->result_array();
    }

    function PengeluaranADM()
    {
        $query = $this->db->query("SELECT * FROM `tbl_pengeluaran_toko` a WHERE a.tipe = 'ADM'");
        return $query->result_array();
    }

    function penerima_tf()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT 
        * 
        FROM
            `transaksi_tfsantri` a 
        LEFT JOIN tbl_siswa b ON b.`nis`=a.`nis`
        WHERE a.`nis_penerima` = '$nis' ");
        return $query->result();
    }

    function pengirim_tf()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT 
        * 
        FROM
            `transaksi_tfsantri` a 
        LEFT JOIN tbl_siswa b ON b.`nis`=a.`nis`
        WHERE a.`nis` = '$nis'");
        return $query->result();
    }

    function bulanan_trans()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT * FROM `tbl_transaksi` a WHERE a.`kd_tabungan` = '$nis'");
        return $query->result();
    }

    function tabungan_trans()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                a.`nis`,
                a.`nama`,
                a.`jml_simpan`,
                a.`waktu`  ");
        $this->db->from('tbl_tabungan_tahunan_riwayat a');
        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.waktu', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.waktu >=', $tglawal);
                $this->db->where('a.waktu <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function tabungan_trans_santri($nis)
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT * FROM `tbl_tabungan_tahunan_riwayat` a WHERE a.`nis` = '$nis'");
        return $query->result();
    }

    function penarikan_tabungan_tahunan($nis)
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT * FROM `tbl_penarikantabungan` a WHERE a.`nis` = '$nis'");
        return $query->result();
    }

    function total_tabungan()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT * FROM `tbl_tabungan_tahunan` a");
        return $query->result_array();
    }

    function pengajuan_tarik_tabungan()
    {
        $nis = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT * FROM `tbl_penarikantabungan` WHERE status = '0'");
        return $query->result_array();
    }

    function cek()
    {
        $query = $this->db->query("SELECT SUM(a.`jumlah_denda`) AS total  FROM `tbl_denda` a");
        if ($query->num_rows() > 0) {
            return $query->row()->total;
        } else {
            return 0;
        }
    }

    function saldoToko()
    {
        $id = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`tipe` = ' $id'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }

    function saldoTokoA()
    {
        $id = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`id` = '2'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }


    function saldoTokoB()
    {
        $id = $this->session->userdata('ses_id');
        $query = $this->db->query("SELECT a.`jumlah_saldo` FROM `tbl_saldo` a WHERE a.`id` = '3'");
        if ($query->num_rows() > 0) {
            return $query->row()->jumlah_saldo;
        } else {
            return 0;
        }
    }


    function tariktunai_search()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select(" 
            a.`nis`,
            a.`nama_siswa`,
            a.`nama_siswa`,
            a.`jml_tarik`,
            a.`waktu` ");
        $this->db->from('tbl_penarikansantri a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            if (empty($tglakhir)) {
                $this->db->where('a.waktu', $tglawal);
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.waktu >=', $tglawal);
                $this->db->where('a.waktu <=', $tglakhir);
            }
            $L    = true;
        }

        // $this->db->group_by('a.kd', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function tariktabungan_search()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select(" 
                    a.`nis`,
                    a.`nama_siswa`,
                    a.`jml_tarik`,
                    DATE(a.`waktu`) AS waktu ");
        $this->db->from('tbl_penarikantabungan a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;
            if (empty($tglakhir)) {
                $this->db->where('a.waktu', $tglawal);
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.waktu >=', $tglawal);
                $this->db->where('a.waktu <=', $tglakhir);
            }
            $L    = true;
        }

        // $this->db->group_by('a.kd', 'DESC');

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function search_denda()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`nis`,
        a.`jumlah_denda`,
        a.`keterangan`,
        DATE(a.`date`) AS date ");
        $this->db->from('tbl_denda a');
        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.date', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.date >=', $tglawal);
                $this->db->where('a.date <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function search_adminbiaya()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`ket_data`,
        a.`isi_data`,
        a.`waktu`");
        $this->db->from('tbl_data a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.waktu', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.waktu >=', $tglawal);
                $this->db->where('a.waktu <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function search_pengeluaranInfaq()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`keperluan`,
        a.`dana`,
        a.`request`,
        a.`dibuat`,
        a.`tipe`");
        $this->db->from('tbl_pengeluaran_infaq a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.dibuat', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.dibuat >=', $tglawal);
                $this->db->where('a.dibuat <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function search_pengeluarantoko()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`keperluan`,
        a.`dana`,
        a.`request`,
        a.`dibuat`,
        a.`tipe`");
        $this->db->from('tbl_pengeluaran_toko a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.dibuat', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.dibuat >=', $tglawal);
                $this->db->where('a.dibuat <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function search_pengeluarantokoB()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`keperluan`,
        a.`dana`,
        a.`request`,
        a.`dibuat`,
        a.`tipe`");
        $this->db->from('tbl_pengeluaran_toko_b a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.dibuat', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.dibuat >=', $tglawal);
                $this->db->where('a.dibuat <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }

    function search_pengeluaranDenda()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
        a.`keperluan`,
        a.`dana`,
        a.`request`,
        a.`dibuat`,
        a.`tipe`");
        $this->db->from('tbl_pengeluaran_denda a');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.dibuat', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.dibuat >=', $tglawal);
                $this->db->where('a.dibuat <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }


    function search_pengeluaranadmin()
    {

        $tglawal = $this->input->post('tgl_awal');
        $tglakhir = $this->input->post('tgl_akhir');
        $return    = null;
        $this->db->select("
                a.`keperluan`,
                a.`dana`,
                a.`request`,
                a.`dibuat`,
                a.`tipe`");
        $this->db->from('tbl_pengeluaran_toko a');
        $this->db->where('a.tipe', 'ADM');

        $L    = false;
        $search    = [];

        if ($this->input->post()) {
            $this->session->unset_userdata('search');
            foreach ($this->input->post() as $key => $val) {
                ${$key}    = $val;
                $search[$key]    = $val;
            }
            $this->session->set_userdata('search', $search);
        } else {
            if (!empty($this->session->userdata('search'))) {
                foreach ($this->session->userdata('search') as $key => $val) {
                    ${$key}    = $val;
                    $search[$key]    = $val;
                }
            }
        }

        if (!empty($search)) {
            $L    = false;

            if (empty($tglakhir)) {
                $this->db->where('a.dibuat', $tglawal);
                $L    = true;
            } else if (!empty($tglawal && $tglakhir)) {
                $this->db->where('a.dibuat >=', $tglawal);
                $this->db->where('a.dibuat <=', $tglakhir);
                $L    = true;
            }
        }

        if ($L    === true) {
            $query    = $this->db->get();
            if ($query->num_rows() > 0) {
                $return    = $query->result_array();
            }
        }

        return $return;
    }
}
