<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('MLogin');
		$this->load->model('MSudi');
	}

	public function index()
	{
		$maintenance = $this->MSudi->GetDataWhere('tbl_tahun_ajaran', 'kd', 1)->row();
		$mt = $maintenance->thn_ajaran;
		if ($mt == 3) {
			$this->load->library('session');
			$this->session->unset_userdata('ses_nama');
			$this->session->unset_userdata('ses_id');
			$this->session->unset_userdata('akses');
			$this->load->view('Maintenance');
		} else {
			$this->load->library('session');
			$this->session->unset_userdata('ses_nama');
			$this->session->unset_userdata('ses_id');
			$this->session->unset_userdata('akses');
			$this->load->view('login/splash');
		}
	}

	public function Loginpage()
	{
		$maintenance = $this->MSudi->GetDataWhere('tbl_tahun_ajaran', 'kd', 1)->row();
		$mt = $maintenance->thn_ajaran;
		if ($mt == 3) {
			$this->load->library('session');
			$this->session->unset_userdata('ses_nama');
			$this->session->unset_userdata('ses_id');
			$this->session->unset_userdata('akses');
			$this->load->view('Maintenance');
		} else {
			$this->load->library('session');
			$this->session->unset_userdata('ses_nama');
			$this->session->unset_userdata('ses_id');
			$this->session->unset_userdata('akses');
			$this->load->view('login/vLogin');
		}
	}

	public function Auth()
	{
		$username = $this->input->post('username', true); // Sanitasi input
		$password = $this->input->post('password', true); // Sanitasi input
		
		// Validasi input
		if (empty($username) || empty($password)) {
		    $this->session->set_flashdata('msg', '<div class="alert alert-danger" role="alert">Username atau password tidak boleh kosong</div>');
      		redirect('Login/Loginpage');
			return;
		}
		
		$cek_mahasiswa = $this->MLogin->auth_siswa($username, $password);
		
		if ($cek_mahasiswa) {
			// Set session data
			$this->session->set_userdata('masuk', TRUE);
			$this->session->set_userdata('akses', '3');
			$this->session->set_userdata('ses_id', $cek_mahasiswa->nis);
			$this->session->set_userdata('ses_nisn', $cek_mahasiswa->nisn);
			$this->session->set_userdata('ses_nama', $cek_mahasiswa->nama_siswa);
			$this->session->set_userdata('ses_idsaldo', $cek_mahasiswa->kd_tabungan);
			$this->session->set_userdata('ses_saldo', $cek_mahasiswa->jml_nabung);
	
			// Set flash data message
			$this->session->set_flashdata('msg', '<div id="menu-welcome-modal" class="menu menu-box-modal menu-box-round-medium menu-box-detached rounded-s" 
			data-menu-width="310"
			data-menu-height="170"
			data-menu-effect="menu-over"
			data-menu-select="page-components">
			<div class="boxed-text-xl mt-4">
				<h1 class="mb-3"><i class="fa fa-check-circle color-green1-dark fa-3x"></i></h1>
				<h2 class="font-700 mb-n1">Selamat Datang</h2>
				<p class="color-highlight">' . $this->session->userdata('ses_nama') . '!</p>
				</div>
			</div>');
			
			// Redirect to welcome page
			redirect('welcome');
		} else {  // jika username dan password tidak ditemukan atau salah
		    $this->session->set_flashdata('msg', '<div class="alert alert-danger" role="alert">Username atau password salah</div>');		
			// Redirect to login page
			redirect('Login/Loginpage');
		}
	}
	

	public function blok()
	{
		$this->load->view('404');
	}

	public function in()
	{
		$this->load->view('new/loginPage');
	}
	public function loadMenuFooter()
	{
		$this->load->view('template/component/menu-footer');
	}
	public function loadMenuShare()
	{
		$this->load->view('template/component/menu-share');
	}	
	public function loadMenuMain()
	{
		$this->load->view('template/component/menu-main');
	}

	public function Logout()
    {
        $this->load->library('session');
        $this->session->unset_userdata('ses_nama');
        $this->session->unset_userdata('ses_id');
        $this->session->unset_userdata('akses');
		redirect(site_url('Login/Loginpage'));
    }
}
